# Understanding Java’s LinkedList Class

The `LinkedList` class in Java is part of the **Collections Framework** and implements the `List` interface.
Unlike an `ArrayList`, which stores elements in a contiguous array, a `LinkedList` uses **nodes** that are linked together — each node holds a value and a reference to the next (and previous) node.

---

## Code Overview

This program demonstrates key LinkedList operations:

1. **Initialization and Conversion**

   - Two arrays (`colors1`, `colors2`) are converted into `LinkedList` objects using the `Arrays.asList()` method and the LinkedList constructor.

2. **Merging Lists**

   - `addAll()` combines both lists into one.

3. **Reverse Traversal**

   - `printReversedList()` uses a `ListIterator` starting from the end to print items backward.

4. **In-Place Modification**

   - `convertToUpperCase()` traverses the list and replaces each element with its uppercase version using `ListIterator.set()`.

5. **Sublist Removal**

   - `removeItems()` uses `subList(start, end).clear()` to delete a range of elements efficiently.

---

## Challenges

Try to **re-implement** the following methods _without using a `ListIterator`_:

1. `printReversedList()`
2. `convertToUpperCase()`
